#pragma once
#include "Config.h"

/////////////////////////////////////////////////////////////////////////////
#define kCfgEventFunChange				6000
#define	kCfgEventPowChange				6001
/////////////////////////////////////////////////////////////////////////////

#define	kPowSection						"POW"

#define kPowPhoneKey					"Phone"
#define	kPowPowerLevelKey				"Level"
#define	kPowBatteryStatusKey			"Status"
#define	kPowPhoneFunctionalityKey		"Func"

#define	kDefaultPowerLevel				75
#define kDefaultBatteryStatus			eTelPowBatteryPowered
#define	kDefaultPhoneFunctionality		0
#define	kDefaultPhonePower				0

/////////////////////////////////////////////////////////////////////////////
enum 
{
	eTelPowBatteryPowered,
	eTelPowBatteryNotPowered,
	eTelPowNoBattery,
	eTelPowBatteryFault,
	eTelPowStatusLastValue
};
/////////////////////////////////////////////////////////////////////////////
/*Phone Functionality values:
0 minimum functionality
1 full functionality
2 disable phone transmit RF circuits only
3 disable phone receive RF circuits only
4 disable phone both transmit and receive RF circuits
*/
/////////////////////////////////////////////////////////////////////////////

#ifdef DLLMANAGER_EXPORTS
	#define DLLMANAGER_API __declspec(dllexport)
#else
	#define DLLMANAGER_API __declspec(dllimport)
#endif
///////////////////////////////////////////////////////////////////////////////

class DLLMANAGER_API CConfigPOW :
	public CConfig
{
private:
	int					mBatteryStatus;
	UInt8				mPowerLevel;
	UInt8				mPhoneFunctionality;
    UInt8				mPhonePower;
public:
	CConfigPOW() {};
	CConfigPOW(CDllManager* iDllManager);
	virtual ~CConfigPOW(void);

	/*Common Config interface*/
	virtual Bool Save();
	virtual Bool Load();

	/*Accessors*/
	virtual UInt8 GetPowerLevel();
	virtual void SetPowerLevel(UInt8 iPowerLevel);
	virtual UInt8 GetPhoneFunctionality();
	virtual void SetPhoneFunctionality(UInt8 iFun);
	virtual UInt8 GetBatState();
	virtual void SetBatState(UInt8 iBatState);
	virtual UInt8 GetPhonePower();
	virtual void SetPhonePower(UInt8 iPhonePower);

protected:
	DECLARE_SERIAL(CConfigPOW);
};
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
